<?php

namespace App\Http\Resources\Lab;

use Illuminate\Http\Resources\Json\JsonResource;

class LabResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            "lab_logo" => $this->lab_logo_url 
                ? url('uploads/lab_logos/' . $this->lab_logo_url) 
                : 'https://placehold.co/300x200?text=No+Image',
        ];
    }
}